@extends('admin-layouts.master')

@section('title', 'SP-MPT Baru')

@push('styles')
<style>
    body {
        background-color: #f8f9fa;
    }
    
    .header-gradient {
        background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
        color: white;
        padding: 1rem;
        border-radius: 0;
    }
    
    .card {
        border: none;
        box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,0.075);
        margin-bottom: 1.5rem;
    }
    
    .section-title {
        font-size: 0.875rem;
        font-weight: 600;
        text-transform: uppercase;
        color: #495057;
        margin-bottom: 1rem;
        padding-bottom: 0.5rem;
        border-bottom: 2px solid #dee2e6;
    }
    
    .form-control:focus {
        border-color: #28a745;
        box-shadow: 0 0 0 0.2rem rgba(40, 167, 69, 0.25);
    }
    
    .required {
        color: #dc3545;
    }
    
    .upload-area {
        border: 2px dashed #dee2e6;
        border-radius: 0.25rem;
        padding: 2rem;
        text-align: center;
        cursor: pointer;
        transition: all 0.3s;
        background-color: #fafafa;
    }
    
    .upload-area:hover {
        background-color: #e9ecef;
        border-color: #28a745;
    }
    
    .floating-buttons {
        position: fixed;
        bottom: 1rem;
        right: 1rem;
        z-index: 1000;
    }
    
    .btn-circle {
        width: 3rem;
        height: 3rem;
        border-radius: 50%;
        margin: 0.25rem;
        box-shadow: 0 0.25rem 0.5rem rgba(0,0,0,0.15);
    }
    
    #map {
        height: 400px;
        width: 100%;
        border: 1px solid #dee2e6;
        border-radius: 0.25rem;
    }
    
    .coordinate-input {
        font-size: 0.875rem;
    }
    
    @media print {
        .no-print {
            display: none !important;
        }
        
        .card {
            box-shadow: none;
            border: 1px solid #dee2e6;
        }
    }
</style>

<!-- Leaflet CSS -->
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/leaflet.draw/1.0.4/leaflet.draw.css" />
@endpush

@section('content')
<div class="container-fluid">
    <!-- Header -->
    <div class="card">
        <div class="header-gradient mt-3">
            <h5 class="mb-0 font-weight-bold">SP-MPT BARU</h5>
            <small>Surat Pernyataan Melepaskan Penguasaan Tanah</small>
        </div>
    </div>

    <!-- Alerts -->
    @if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="fas fa-check-circle mr-2"></i>{{ session('success') }}
        <button type="button" class="close" data-dismiss="alert">
            <span>&times;</span>
        </button>
    </div>
    @endif

    @if($errors->any())
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <strong><i class="fas fa-exclamation-triangle mr-2"></i>Terdapat kesalahan:</strong>
        <ul class="mb-0 mt-2">
            @foreach($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
        <button type="button" class="close" data-dismiss="alert">
            <span>&times;</span>
        </button>
    </div>
    @endif

    <!-- Main Form -->
    <form method="POST" action="{{ route('sp-sipt.store') }}" enctype="multipart/form-data" id="formSpSipt">
        @csrf
        
        <div class="card">
            <div class="card-body">
                <!-- Nomor Surat -->
                <div class="form-group">
                    <label class="font-weight-bold">Nomor Surat:</label>
                    <input type="text" class="form-control bg-light" value="Otomatis saat disimpan" readonly>
                    <small class="text-muted">*Nomor surat akan digenerate otomatis</small>
                </div>
                <!-- PIHAK PERTAMA -->
                <h6 class="section-title">PIHAK PERTAMA</h6>
                
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label>Nama <span class="required">*</span></label>
                        <input type="text" 
                               class="form-control @error('pemohon_nama') is-invalid @enderror" 
                               name="pemohon_nama" 
                               value="{{ old('pemohon_nama') }}"
                               placeholder="Masukkan nama lengkap"
                               required>
                        @error('pemohon_nama')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="form-group col-md-6">
                        <label>Tempat/Tanggal Lahir</label>
                        <div class="input-group">
                            <input type="text" 
                                   class="form-control @error('pemohon_tempat_lahir') is-invalid @enderror" 
                                   name="pemohon_tempat_lahir" 
                                   value="{{ old('pemohon_tempat_lahir') }}"
                                   placeholder="Tempat lahir">
                            <input type="date" 
                                   class="form-control @error('pemohon_tanggal_lahir') is-invalid @enderror" 
                                   name="pemohon_tanggal_lahir" 
                                   value="{{ old('pemohon_tanggal_lahir') }}">
                        </div>
                    </div>
                </div>

                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label>Nomor KTP <span class="required">*</span></label>
                        <input type="text" 
                               class="form-control @error('pemohon_nik') is-invalid @enderror" 
                               name="pemohon_nik" 
                               value="{{ old('pemohon_nik') }}"
                               placeholder="16 digit NIK"
                               maxlength="16"
                               pattern="[0-9]{16}"
                               required>
                        @error('pemohon_nik')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="form-group col-md-6">
                        <label>Pekerjaan</label>
                        <input type="text" 
                               class="form-control @error('pemohon_pekerjaan') is-invalid @enderror" 
                               name="pemohon_pekerjaan" 
                               value="{{ old('pemohon_pekerjaan') }}"
                               placeholder="Masukkan pekerjaan">
                    </div>
                </div>

                <div class="form-group">
                    <label>Alamat <span class="required">*</span></label>
                    <textarea class="form-control @error('pemohon_alamat') is-invalid @enderror" 
                              name="pemohon_alamat" 
                              rows="2"
                              placeholder="Masukkan alamat lengkap"
                              required>{{ old('pemohon_alamat') }}</textarea>
                    @error('pemohon_alamat')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <!-- PIHAK KEDUA -->
                <h6 class="section-title mt-4">PIHAK KEDUA</h6>
                
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label>Nama <span class="required">*</span></label>
                        <input type="text" 
                               class="form-control @error('terlapor_nama') is-invalid @enderror" 
                               name="terlapor_nama" 
                               value="{{ old('terlapor_nama') }}"
                               placeholder="Masukkan nama lengkap"
                               required>
                        @error('terlapor_nama')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="form-group col-md-6">
                        <label>Tempat/Tanggal Lahir</label>
                        <div class="input-group">
                            <input type="text" 
                                   class="form-control @error('terlapor_tempat_lahir') is-invalid @enderror" 
                                   name="terlapor_tempat_lahir" 
                                   value="{{ old('terlapor_tempat_lahir') }}"
                                   placeholder="Tempat lahir">
                            <input type="date" 
                                   class="form-control @error('terlapor_tanggal_lahir') is-invalid @enderror" 
                                   name="terlapor_tanggal_lahir" 
                                   value="{{ old('terlapor_tanggal_lahir') }}">
                        </div>
                    </div>
                </div>

                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label>Nomor KTP</label>
                        <input type="text" 
                               class="form-control @error('terlapor_nik') is-invalid @enderror" 
                               name="terlapor_nik" 
                               value="{{ old('terlapor_nik') }}"
                               placeholder="16 digit NIK"
                               maxlength="16"
                               pattern="[0-9]{16}">
                        @error('terlapor_nik')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="form-group col-md-6">
                        <label>Pekerjaan</label>
                        <input type="text" 
                               class="form-control @error('terlapor_pekerjaan') is-invalid @enderror" 
                               name="terlapor_pekerjaan" 
                               value="{{ old('terlapor_pekerjaan') }}"
                               placeholder="Masukkan pekerjaan">
                    </div>
                </div>

                <div class="form-group">
                    <label>Alamat</label>
                    <textarea class="form-control @error('terlapor_alamat') is-invalid @enderror" 
                              name="terlapor_alamat" 
                              rows="2"
                              placeholder="Masukkan alamat lengkap">{{ old('terlapor_alamat') }}</textarea>
                    @error('terlapor_alamat')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <!-- DATA TANAH -->
                <h6 class="section-title mt-4">DATA TANAH</h6>
                
                <div class="form-row">
                    <div class="form-group col-md-2">
                        <label>Status RT</label>
                        <input type="text" 
                               class="form-control @error('lokasi_rt') is-invalid @enderror" 
                               name="lokasi_rt" 
                               value="{{ old('lokasi_rt') }}"
                               placeholder="001"
                               maxlength="3">
                    </div>
                    
                    <div class="form-group col-md-2">
                        <label>Status RW</label>
                        <input type="text" 
                               class="form-control @error('lokasi_rw') is-invalid @enderror" 
                               name="lokasi_rw" 
                               value="{{ old('lokasi_rw') }}"
                               placeholder="001"
                               maxlength="3">
                    </div>
                    
                    <div class="form-group col-md-8">
                        <label>Kepala Kampung</label>
                        <input type="text" 
                               class="form-control @error('kepala_kampung') is-invalid @enderror" 
                               name="kepala_kampung" 
                               value="{{ old('kepala_kampung') }}"
                               placeholder="Nama kepala kampung">
                    </div>
                </div>

                <div class="form-row">
                    <div class="form-group col-md-4">
                        <label>Kelurahan</label>
                        <input type="text" 
                               class="form-control @error('lokasi_kelurahan') is-invalid @enderror" 
                               name="lokasi_kelurahan" 
                               value="{{ old('lokasi_kelurahan') }}"
                               placeholder="Nama kelurahan">
                    </div>
                    
                    <div class="form-group col-md-4">
                        <label>Kecamatan</label>
                        <input type="text" 
                               class="form-control @error('lokasi_kecamatan') is-invalid @enderror" 
                               name="lokasi_kecamatan" 
                               value="{{ old('lokasi_kecamatan') }}"
                               placeholder="Nama kecamatan">
                    </div>
                    
                    <div class="form-group col-md-4">
                        <label>Kota/Kabupaten</label>
                        <input type="text" 
                               class="form-control @error('lokasi_kota') is-invalid @enderror" 
                               name="lokasi_kota" 
                               value="{{ old('lokasi_kota', 'Balikpapan') }}"
                               placeholder="Nama kota">
                    </div>
                </div>

                <!-- BATAS-BATAS TANAH -->
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label>Utara</label>
                        <input type="text" 
                               class="form-control @error('batas_utara') is-invalid @enderror" 
                               name="batas_utara" 
                               value="{{ old('batas_utara') }}"
                               placeholder="Berbatasan dengan...">
                    </div>
                    
                    <div class="form-group col-md-6">
                        <label>Timur</label>
                        <input type="text" 
                               class="form-control @error('batas_timur') is-invalid @enderror" 
                               name="batas_timur" 
                               value="{{ old('batas_timur') }}"
                               placeholder="Berbatasan dengan...">
                    </div>
                </div>

                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label>Selatan</label>
                        <input type="text" 
                               class="form-control @error('batas_selatan') is-invalid @enderror" 
                               name="batas_selatan" 
                               value="{{ old('batas_selatan') }}"
                               placeholder="Berbatasan dengan...">
                    </div>
                    
                    <div class="form-group col-md-6">
                        <label>Barat</label>
                        <input type="text" 
                               class="form-control @error('batas_barat') is-invalid @enderror" 
                               name="batas_barat" 
                               value="{{ old('batas_barat') }}"
                               placeholder="Berbatasan dengan...">
                    </div>
                </div>

                <!-- PERNYATAAN -->
                <h6 class="section-title mt-4">PERNYATAAN</h6>
                
                <div class="form-group">
                    <div class="custom-control custom-checkbox">
                        <input type="checkbox" 
                               class="custom-control-input" 
                               id="pernyataan1" 
                               name="pernyataan_kebenaran"
                               value="1"
                               {{ old('pernyataan_kebenaran') ? 'checked' : '' }}>
                        <label class="custom-control-label" for="pernyataan1">
                            <strong>Bukti Perolehan/Pemilikan Tanah:</strong> 
                            Saya menyatakan dengan sebenarnya bahwa tanah tersebut benar-benar milik saya.
                        </label>
                    </div>
                </div>

                <div class="form-group">
                    <div class="custom-control custom-checkbox">
                        <input type="checkbox" 
                               class="custom-control-input" 
                               id="pernyataan2" 
                               name="kesediaan_mediasi"
                               value="1"
                               {{ old('kesediaan_mediasi') ? 'checked' : '' }}>
                        <label class="custom-control-label" for="pernyataan2">
                            <strong>Masa Penguasaan:</strong> 
                            Telah dikuasai selama lebih dari 20 tahun secara terus menerus.
                        </label>
                    </div>
                </div>
                <!-- UPLOAD DOKUMEN -->
                <h6 class="section-title mt-4">UPLOAD DOKUMEN</h6>
                
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label>Upload KTP/Dokumen (PDF)</label>
                        <div class="upload-area" onclick="document.getElementById('ktp_file').click()">
                            <i class="fas fa-cloud-upload-alt fa-3x text-muted mb-3"></i>
                            <p class="mb-1">Klik untuk upload file berformat PDF</p>
                            <small class="text-muted">Format: PDF • Maksimal: 5MB</small>
                            <input type="file" 
                                   id="ktp_file"
                                   name="ktp_pemohon" 
                                   class="d-none"
                                   accept=".pdf,image/*"
                                   onchange="showFileInfo(this, 'ktp_preview')">
                            <div id="ktp_preview" class="mt-3"></div>
                        </div>
                        @error('ktp_pemohon')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                    
                    <div class="form-group col-md-6">
                        <label>Upload Dokumen Template</label>
                        <div class="upload-area" onclick="document.getElementById('template_file').click()">
                            <i class="fas fa-cloud-upload-alt fa-3x text-muted mb-3"></i>
                            <p class="mb-1">Klik untuk upload dokumen template</p>
                            <small class="text-muted">Format: PDF, DOC, DOCX • Maksimal: 10MB</small>
                            <input type="file" 
                                   id="template_file"
                                   name="dokumen_template" 
                                   class="d-none"
                                   accept=".pdf,.doc,.docx"
                                   onchange="showFileInfo(this, 'template_preview')">
                            <div id="template_preview" class="mt-3"></div>
                        </div>
                        @error('dokumen_template')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>

                <!-- PETA LOKASI -->
                <h6 class="section-title mt-4">PETA LOKASI TANAH</h6>
                
                <div class="alert alert-info mb-3">
                    <i class="fas fa-info-circle mr-2"></i>
                    <strong>Cara menggambar polygon:</strong> 
                    Klik tombol polygon di peta, lalu klik untuk menambah titik. Klik titik pertama untuk menutup.
                </div>
                
                <div id="map"></div>
                
                <!-- Hidden inputs for coordinates -->
                <input type="hidden" name="latitude" id="latitude" value="{{ old('latitude') }}">
                <input type="hidden" name="longitude" id="longitude" value="{{ old('longitude') }}">
                <input type="hidden" name="polygon_coordinates" id="polygon_coordinates" value="{{ old('polygon_coordinates') }}">

                <!-- Coordinate Display -->
                <div class="form-row mt-3">
                    <div class="form-group col-md-3">
                        <label class="small text-muted">X1 (Lat) / Y1 (Long)</label>
                        <div class="input-group input-group-sm">
                            <input type="text" class="form-control coordinate-input" id="x1" readonly>
                            <input type="text" class="form-control coordinate-input" id="y1" readonly>
                        </div>
                    </div>
                    <div class="form-group col-md-3">
                        <label class="small text-muted">X2 / Y2</label>
                        <div class="input-group input-group-sm">
                            <input type="text" class="form-control coordinate-input" id="x2" readonly>
                            <input type="text" class="form-control coordinate-input" id="y2" readonly>
                        </div>
                    </div>
                    <div class="form-group col-md-3">
                        <label class="small text-muted">X3 / Y3</label>
                        <div class="input-group input-group-sm">
                            <input type="text" class="form-control coordinate-input" id="x3" readonly>
                            <input type="text" class="form-control coordinate-input" id="y3" readonly>
                        </div>
                    </div>
                    <div class="form-group col-md-3">
                        <label class="small text-muted">X4 / Y4</label>
                        <div class="input-group input-group-sm">
                            <input type="text" class="form-control coordinate-input" id="x4" readonly>
                            <input type="text" class="form-control coordinate-input" id="y4" readonly>
                        </div>
                    </div>
                </div>
                
                <small class="text-muted">
                    <i class="fas fa-info-circle"></i> 
                    Koordinat terisi otomatis saat menggambar polygon di peta
                </small>

                <!-- KRONOLOGI -->
                <h6 class="section-title mt-4">KETERANGAN</h6>
                
                <div class="form-group">
                    <label>Kronologi <span class="required">*</span></label>
                    <textarea class="form-control @error('kronologi') is-invalid @enderror" 
                              name="kronologi" 
                              rows="4"
                              placeholder="Jelaskan kronologi permasalahan..."
                              required>{{ old('kronologi') }}</textarea>
                    @error('kronologi')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <!-- ACTION BUTTONS -->
                <div class="form-group mt-4">
                    <button type="submit" class="btn btn-success px-4">
                        <i class="fas fa-save mr-2"></i>Simpan
                    </button>
                    <button type="reset" class="btn btn-secondary px-4">
                        <i class="fas fa-undo mr-2"></i>Batal
                    </button>
                </div>
            </div>
        </div>
    </form>

    <!-- Floating Buttons -->
    <div class="floating-buttons no-print">
        <button type="button" class="btn btn-primary btn-circle" onclick="scrollToBottom()" title="Ke Bawah">
            <i class="fas fa-arrow-down"></i>
        </button>
        <button type="button" class="btn btn-success btn-circle" title="Edit">
            <i class="fas fa-edit"></i>
        </button>
        <button type="button" class="btn btn-warning btn-circle text-white" onclick="window.print()" title="Cetak">
            <i class="fas fa-print"></i>
        </button>
        <button type="button" class="btn btn-danger btn-circle" onclick="confirmDelete()" title="Hapus">
            <i class="fas fa-trash"></i>
        </button>
    </div>
</div>
@endsection
@push('scripts')
<!-- Leaflet JS -->
<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/leaflet.draw/1.0.4/leaflet.draw.js"></script>

<script>
// Global variables
let map;
let drawnItems;
let currentPolygon = null;
let currentMarker = null;

// Initialize when document ready
$(document).ready(function() {
    initializeMap();
    initializeValidation();
});

// Initialize Leaflet Map
function initializeMap() {
    // Create map centered on Balikpapan
    map = L.map('map').setView([-1.2379, 116.8529], 13);

    // Add tile layer
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        attribution: '© OpenStreetMap contributors',
        maxZoom: 19
    }).addTo(map);

    // Satellite layer
    var satellite = L.tileLayer('https://server.arcgisonline.com/ArcGIS/rest/services/World_Imagery/MapServer/tile/{z}/{y}/{x}', {
        attribution: '© Esri'
    });

    // Layer control
    L.control.layers({
        "Street Map": L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png'),
        "Satellite": satellite
    }).addTo(map);

    // Initialize FeatureGroup for drawn layers
    drawnItems = new L.FeatureGroup();
    map.addLayer(drawnItems);

    // Initialize drawing control
    var drawControl = new L.Control.Draw({
        position: 'topleft',
        draw: {
            polygon: {
                allowIntersection: false,
                drawError: {
                    color: '#e1e100',
                    message: 'Polygon tidak boleh berpotongan!'
                },
                shapeOptions: {
                    color: '#ff0000',
                    weight: 3,
                    fillColor: '#ffff00',
                    fillOpacity: 0.35
                }
            },
            polyline: false,
            circle: false,
            circlemarker: false,
            rectangle: false,
            marker: true
        },
        edit: {
            featureGroup: drawnItems,
            remove: true
        }
    });
    map.addControl(drawControl);

    // Event: Created
    map.on(L.Draw.Event.CREATED, function (e) {
        var type = e.layerType;
        var layer = e.layer;

        if (type === 'polygon') {
            // Remove existing polygon
            if (currentPolygon) {
                drawnItems.removeLayer(currentPolygon);
            }
            
            currentPolygon = layer;
            drawnItems.addLayer(layer);
            
            // Get coordinates and update display
            var coordinates = layer.getLatLngs()[0];
            updatePolygonCoordinates(coordinates);
            savePolygonData(coordinates);
        }
        
        if (type === 'marker') {
            // Remove existing marker
            if (currentMarker) {
                drawnItems.removeLayer(currentMarker);
            }
            
            currentMarker = layer;
            drawnItems.addLayer(layer);
            
            // Save marker position
            var position = layer.getLatLng();
            $('#latitude').val(position.lat.toFixed(6));
            $('#longitude').val(position.lng.toFixed(6));
        }
    });

    // Event: Edited
    map.on(L.Draw.Event.EDITED, function (e) {
        var layers = e.layers;
        layers.eachLayer(function (layer) {
            if (layer instanceof L.Polygon) {
                var coordinates = layer.getLatLngs()[0];
                updatePolygonCoordinates(coordinates);
                savePolygonData(coordinates);
            }
        });
    });

    // Event: Deleted
    map.on(L.Draw.Event.DELETED, function (e) {
        var layers = e.layers;
        layers.eachLayer(function (layer) {
            if (layer === currentPolygon) {
                currentPolygon = null;
                clearCoordinates();
            }
            if (layer === currentMarker) {
                currentMarker = null;
                $('#latitude').val('');
                $('#longitude').val('');
            }
        });
    });

    // Load existing polygon if available
    loadExistingPolygon();
}

// Update polygon coordinates display
function updatePolygonCoordinates(coordinates) {
    // Clear all inputs
    clearCoordinates();
    
    // Fill coordinate inputs (max 4 points)
    var maxPoints = Math.min(coordinates.length, 4);
    for (var i = 0; i < maxPoints; i++) {
        $('#x' + (i + 1)).val(coordinates[i].lat.toFixed(6));
        $('#y' + (i + 1)).val(coordinates[i].lng.toFixed(6));
    }
    
    // Set center as main coordinates
    if (coordinates.length > 0) {
        var bounds = L.latLngBounds(coordinates);
        var center = bounds.getCenter();
        $('#latitude').val(center.lat.toFixed(6));
        $('#longitude').val(center.lng.toFixed(6));
    }
}

// Save polygon data
function savePolygonData(coordinates) {
    var coordArray = coordinates.map(function(coord) {
        return [coord.lat, coord.lng];
    });
    $('#polygon_coordinates').val(JSON.stringify(coordArray));
}

// Load existing polygon
function loadExistingPolygon() {
    var polygonData = $('#polygon_coordinates').val();
    if (polygonData) {
        try {
            var coordinates = JSON.parse(polygonData);
            var latLngs = coordinates.map(function(coord) {
                return L.latLng(coord[0], coord[1]);
            });
            
            currentPolygon = L.polygon(latLngs, {
                color: '#ff0000',
                weight: 3,
                fillColor: '#ffff00',
                fillOpacity: 0.35
            });
            
            drawnItems.addLayer(currentPolygon);
            map.fitBounds(currentPolygon.getBounds());
            updatePolygonCoordinates(latLngs);
        } catch (e) {
            console.error('Error loading polygon:', e);
        }
    }
}

// Clear coordinate inputs
function clearCoordinates() {
    for (var i = 1; i <= 4; i++) {
        $('#x' + i).val('');
        $('#y' + i).val('');
    }
    $('#polygon_coordinates').val('');
}

// File upload handler
function showFileInfo(input, previewId) {
    var file = input.files[0];
    if (file) {
        var fileName = file.name;
        var fileSize = (file.size / 1024 / 1024).toFixed(2);
        
        $('#' + previewId).html(`
            <div class="alert alert-success">
                <i class="fas fa-file-pdf mr-2"></i>
                <strong>${fileName}</strong> (${fileSize} MB)
                <button type="button" class="close" onclick="clearFile('${input.id}', '${previewId}')">
                    <span>&times;</span>
                </button>
            </div>
        `);
    }
}

// Clear file input
function clearFile(inputId, previewId) {
    $('#' + inputId).val('');
    $('#' + previewId).html('');
}

// Form validation
function initializeValidation() {
    // NIK validation
    $('input[name="pemohon_nik"], input[name="terlapor_nik"]').on('input', function() {
        this.value = this.value.replace(/[^0-9]/g, '').substring(0, 16);
    });

    // RT/RW formatting
    $('input[name="lokasi_rt"], input[name="lokasi_rw"]').on('input', function() {
        var value = this.value.replace(/[^0-9]/g, '');
        if (value.length > 0) {
            this.value = value.padStart(3, '0').substring(0, 3);
        }
    });

    // Form submit validation
    $('#formSpSipt').on('submit', function(e) {
        var isValid = true;
        var errors = [];

        // Check required fields
        var requiredFields = {
            'pemohon_nama': 'Nama Pihak Pertama',
            'pemohon_nik': 'NIK Pihak Pertama', 
            'pemohon_alamat': 'Alamat Pihak Pertama',
            'terlapor_nama': 'Nama Pihak Kedua',
            'kronologi': 'Kronologi'
        };

        $.each(requiredFields, function(field, label) {
            var value = $('[name="' + field + '"]').val();
            if (!value || value.trim() === '') {
                errors.push(label + ' harus diisi');
                $('[name="' + field + '"]').addClass('is-invalid');
                isValid = false;
            }
        });

        // Check NIK length
        var nik = $('input[name="pemohon_nik"]').val();
        if (nik && nik.length !== 16) {
            errors.push('NIK harus 16 digit');
            isValid = false;
        }

        // Check checkbox
        if (!$('#pernyataan1').is(':checked') && !$('#pernyataan2').is(':checked')) {
            errors.push('Minimal satu pernyataan harus dicentang');
            isValid = false;
        }

        if (!isValid) {
            e.preventDefault();
            
            // Show errors
            if (errors.length > 0) {
                var errorMsg = '<ul class="mb-0">';
                errors.forEach(function(error) {
                    errorMsg += '<li>' + error + '</li>';
                });
                errorMsg += '</ul>';
                
                // Using Bootstrap 4 modal instead of SweetAlert
                $('#errorModal').remove();
                $('body').append(`
                    <div class="modal fade" id="errorModal" tabindex="-1">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header bg-danger text-white">
                                    <h5 class="modal-title">Validasi Gagal</h5>
                                    <button type="button" class="close text-white" data-dismiss="modal">
                                        <span>&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    ${errorMsg}
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Tutup</button>
                                </div>
                            </div>
                        </div>
                    </div>
                `);
                $('#errorModal').modal('show');
            }
            
            // Scroll to first invalid field
            var firstInvalid = $('.is-invalid').first();
            if (firstInvalid.length) {
                $('html, body').animate({
                    scrollTop: firstInvalid.offset().top - 100
                }, 500);
            }
        }
    });

    // Remove invalid class on input
    $('input, textarea').on('input', function() {
        $(this).removeClass('is-invalid');
    });
}

// Utility functions
function scrollToBottom() {
    $('html, body').animate({
        scrollTop: $(document).height()
    }, 1000);
}

function confirmDelete() {
    if (confirm('Apakah Anda yakin ingin menghapus data ini?')) {
        window.location.href = '{{ route("sp-sipt.index") }}';
    }
}

// Auto-save draft
var autoSaveTimer;
$('input, textarea, select').on('input change', function() {
    clearTimeout(autoSaveTimer);
    autoSaveTimer = setTimeout(function() {
        console.log('Auto-saving draft...');
        // Implement auto-save via AJAX if needed
    }, 30000); // 30 seconds
});

// Initialize tooltips
$(function () {
    $('[data-toggle="tooltip"]').tooltip();
});
</script>
@endpush